/*------------------------------------------------------------------------------*
 * File Name: GetPtsDlg.c														*
 * Creation: CPY 2/5/2008														*
 * Purpose: GraphGetPts GUI help to allow Done button on graph					*
 * Copyright (c) OriginLab Corp.2008											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 03-13-2008 FIX_SHOW_X_Y_POS												*
 * Sim 03-14-2008 IMPROVE_GET_POINTS_DLG										*
 *	Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT			*
 *	Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY		*
 *	YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG								*
 *	CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG									*
 *	Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE				*
 *	Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG				*
 *	Jasmine 02/25/09 MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW		*
 *	Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
 *	Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
 *	Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
 *------------------------------------------------------------------------------*/
#include <Origin.h>
#include "DialogEx.h" 

#define STR_LT_VAR_DONE "DoneGetPts"

class	UserGetPts;		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN

class GraphGetPtsDlg : public ResizeDialog
{
public:
	GraphGetPtsDlg() : ResizeDialog( IDD_GRAPH_GETPTS, "oDlg8" )
	{
		/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		m_nMaxLength = -1; // to indicate no need to resize
		/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		
		m_bDeleteOnDestroy = false;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG		
		m_pGetPts = NULL;			///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	}
	//m_bDeleteOnDestroy = true in DoModal
	virtual int  Create(HWND hParent = NULL)
	{
		m_bDeleteOnDestroy = true;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		
		InitMsgMap();
		int nRet = ResizeDialog::Create(hParent);
		return nRet;
	}
	
	/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	BOOL IsAutoSize()
	{
		return m_nMaxLength >= 0? true:false;
	}
	
	void SetAutoSize(BOOL bOn = TRUE)
	{
		m_nMaxLength = bOn? 0:-1;
	}
	/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG	
	
	void ShowMsg(LPCSTR lpcsz)
	{
		m_staticHintLabel.Text = lpcsz;
		/// CPY 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		int nLen = lstrlen(lpcsz);
		if( IsAutoSize() && nLen > 25)
		{
			if(nLen > m_nMaxLength) // will only grow in size
				m_nMaxLength = nLen;
			else
				return;
			
			ResizeControlWidth(m_staticHintLabel, 10, false);
			
			///Jasmine 02/25/09 MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW
			//uint nButtonIDs[] = {IDC_STATIC_NEXTPTS, IDC_DONE, 0};
			uint nButtonIDs[] = {IDC_DONE, IDC_STATIC_NEXTPTS, 0};
			ArrangeControlsLeftRight(nButtonIDs, 0, 0);
			//ResizeDlgToRightOfControl(IDC_DONE, true, true);
			ResizeDlgToRightOfControl(IDC_STATIC_NEXTPTS, true, true);
			///End MOVE_DOONE_BUTTON_TO_MOST_LEFT_TO_SHOW_IN_SMALL_WINDOW
		}
		/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	}
	
	///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	void	SetUserGetPtsPointer(UserGetPts* pGetPts)
	{
		m_pGetPts = pGetPts;
	}
	///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	
protected:

EVENTS_BEGIN
	ON_INIT( OnInitDialog )
	ON_DESTROY(OnDestroy)
	ON_BN_CLICKED(IDC_DONE, OnDone)
	ON_SIZE(OnDlgResize)	
EVENTS_END
	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog();
		m_staticHintLabel = GetItem(IDC_STATIC_NEXTPTS);
		return TRUE;
	}
	BOOL OnDestroy(void)
	{
		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		if ( m_pGetPts )
			m_pGetPts->ResetDlgPointer();
		///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		
		ResizeDialog::OnDestroy();
		
		///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		if(m_bDeleteOnDestroy)
			delete this;
		///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
#ifdef	_DEBUG_
		out_str("GraphGetPtsDlg::Destroy");
#endif		
		return true;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		return TRUE;
	}
	/// Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
	//BOOL OnDone(Control ctrl)
	virtual BOOL OnDone(Control ctrl)
	/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
	{
		LT_execute(STR_LT_VAR_DONE "= 1");
		return true;
	}

///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
protected:
	bool 	m_bDeleteOnDestroy;
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG

private:
	Control	m_staticHintLabel;
	/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	int	m_nMaxLength;
	/// end OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
	
	UserGetPts* m_pGetPts;		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
};

/*
void ggg(int nClose = 0)
{
	_close_dlg();
	if(nClose)
		return;
	
	GraphPage gp = Project.Pages();
	if(!gp)
		return;
	
	Window ww = gp.GetWindow();
	if(!ww)
		return;
	
	HWND hWndParent = ww.GetSafeHwnd();//GetWindow();
	hWndParent = GetWindow(hWndParent, GW_CHILD); 	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
	s_pGetPtsDlg = new GraphGetPtsDlg;
	s_pGetPtsDlg->Create(hWndParent);
	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
	//HWND hWndDlg = NULL;
	//Window wndDlg = *s_pGetPtsDlg;
	//hWndDlg  = wndDlg.GetSafeHwnd();
	//SetWindowPos(hWndDlg, HWND_TOP, 0,0,0,0, SWP_NOSIZE|SWP_NOMOVE);
	/// end CHILD_DIALOG_TO_MDI_CHILD_FRAME
	s_pGetPtsDlg->ShowDialog(false);
}
*/


#define GETPTS_UNKNOWN 100
class UserGetPts : public GetGraphPoints
{
public:
	///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	//UserGetPts(int nCursor, LPCSTR lpcszTitle, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL, bool bAutoResize = true)
	UserGetPts(int nCursor, LPCSTR lpcszTitle, LPCSTR lpcszInitMsg = NULL, LPCSTR lpcszContinueMsg = NULL, bool bAutoResize = true, bool bShowDlg = true)
	///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	{
		m_pGetPtsDlg = NULL;
		/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		//openDlg(bAutoResize);
		/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		m_strInitMsg = lpcszInitMsg;
		m_strContinueFmt = lpcszContinueMsg;
		//----- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
		m_strTitle = lpcszTitle;
		if(m_strTitle.IsEmpty())
			/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
			//m_strTitle = "Get Points";
			m_strTitle = _L("Get Points");
			/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		//-----
		/// Hong 04/05/08 v8.0838 FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE
		///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		//openDlg(bAutoResize);
		if ( bShowDlg ) //since the "Done" button is senseless when select only one point, allow not to it.
		{
			openDlg(bAutoResize);
		}
		///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		/// end FIX_GET_PTS_DLG_FAIL_SPECIFY_DLG_TITLE	
		SetCursor(nCursor);
		
		///------ Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		okutil_enable_origin_gui(FALSE);
		///------ End NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
	}
	~UserGetPts()
	{
		///------ Folger 08/25/09 QA80-14087-P10 NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		okutil_enable_origin_gui(TRUE);
		///------ End NEED_TO_DISABLE_ORIGIN_GUI_WHEN_GET_POINTS_DIALOG_OPEN
		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		if ( m_pGetPtsDlg )
			m_pGetPtsDlg->SetUserGetPtsPointer(NULL);
		///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		closeDlg();
	}
	virtual void OnStart()
	{
		if(m_strInitMsg.IsEmpty())
			m_strInitMsg = "Move to the 1st point and double-click to select it";
		m_strMsg = m_strInitMsg;
		outMsg(m_strMsg);		
	}
	virtual void OnDisplay(string& str, int nPoint)
	{
		GetGraphPoints::OnDisplay(str, nPoint);
		int nTotalPts = GetTotalPoints();
		if(GETPTS_UNKNOWN == nTotalPts)
			nTotalPts = -1; // temp
		
		///---Sim 03-13-2008 FIX_SHOW_X_Y_POS
		/*
		string strFmt = m_strContinueFmt;
		if (strFmt.IsEmpty())
			strFmt = "%d/%d: Double-click to get this point\r\n%s";		
		m_strMsg.Format(strFmt, nPoint+1, nTotalPts, str); // use LT indexing for display
		outMsg(m_strMsg);
		str = m_strMsg;
		*/
		///---Sim 03-14-2008 IMPROVE_GET_POINTS_DLG
		//outMsg(m_strContinueFmt);
		string strFmt;
		strFmt.Format(m_strContinueFmt, nPoint);
		outMsg(strFmt);
		///---END IMPROVE_GET_POINTS_DLG
		///---END FIX_SHOW_X_Y_POS
	}
	///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
	void	ResetDlgPointer()
	{
		m_pGetPtsDlg = NULL;
	}
	///------ End ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
private:
	void closeDlg()
	{
		if(m_pGetPtsDlg)
		{
			Window winDlg = m_pGetPtsDlg->GetWindow();
			if(winDlg)
				winDlg.SendMessage(WM_CLOSE);
		
			//delete m_pGetPtsDlg;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		}
		LT_execute("del -v "  STR_LT_VAR_DONE);
		
		m_pGetPtsDlg = NULL;
	}
	bool openDlg(bool bAutoResize)
	{
		GraphPage gp = Project.Pages();
		if(!gp)
			return false;
		
		//Window ww = gp.GetWindow();
		Window ww = gp.GetWindow(-1); /// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME (Get the drawing window)
		if(!ww)
			return false;
		
		HWND hWndParent = ww.GetSafeHwnd();//GetWindow();
		//hWndParent = GetWindow(hWndParent, GW_CHILD); 	/// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME
		m_pGetPtsDlg = new GraphGetPtsDlg;
		m_pGetPtsDlg->SetUserGetPtsPointer(this);		///------ Folger 04/22/09 QA80-12925-P4 ORIGIN_CRASH_WHEN_NEW_PROJECT_DURING_GETPTSDLG_OPEN
		m_pGetPtsDlg->Create(hWndParent);
		
		m_pGetPtsDlg->SetAutoSize(bAutoResize);/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG
		//---- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
		m_pGetPtsDlg->Text = m_strTitle;
		//----
		m_pGetPtsDlg->ShowDialog(false);
		LT_execute(STR_LT_VAR_DONE  "= 0");
		return true;
	}
	void outMsg(LPCSTR lpcsz)
	{
		if(m_pGetPtsDlg)
			m_pGetPtsDlg->ShowMsg(lpcsz);
	}
private:
	GraphGetPtsDlg* m_pGetPtsDlg;
	
	string m_strInitMsg;
	string m_strContinueFmt;
	string m_strMsg;
	string m_strTitle; //CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
};

/// Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
//int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2)
///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
//int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2, LPCSTR lpcszTitle = NULL, int* pnPlotIndex = NULL)
int GetPtsDlg(vector& vx, vector& vy, int nPts, int nCursorType, LPCSTR lpcszMsg1, LPCSTR lpcszMsg2, LPCSTR lpcszTitle = NULL, int* pnPlotIndex = NULL, vector<int>& vnDatapointIndices = NULL, bool bShowDlg = true, vector<int>& vnDataplotIndices = NULL)
///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
/// end PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
{
	GraphLayer gl = Project.ActiveLayer();
	if(!gl)
		return -1;
	
	if(NULL == lpcszMsg2)
		lpcszMsg2 = lpcszMsg1;
	
	///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	//UserGetPts sp(nCursorType, lpcszTitle, lpcszMsg1, lpcszMsg2);
	UserGetPts sp(nCursorType, lpcszTitle, lpcszMsg1, lpcszMsg2, true, bShowDlg);
	///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	/// Hong 03/26/08 v8/0832b PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
	//sp.SetFollowData(false, 0);
	bool	bFollowData = false;
	int 	nPlotIndex = -1;
	if ( pnPlotIndex != NULL )
	{
		bFollowData	= true;
		nPlotIndex	= *pnPlotIndex;
	}
	sp.SetFollowData(bFollowData, nPlotIndex);
	/// end PA_PEAKS_DEL_REQUIRE_FOLLOWING_DATA_SUPPORT
	if(nPts < 0)
		nPts = GETPTS_UNKNOWN;
	
	//if(sp.GetPoints(GETPTS_UNKNOWN, gl, STR_LT_VAR_DONE) > 0)
	if(sp.GetPoints(nPts, gl, STR_LT_VAR_DONE) > 0) /// Hong 02/27/08 v8.0813 IMPROVE_GET_POINT_OF_SCALE_OFFSET
		///Sophy 8/17/2009 QA80-14087-P3 NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
		//return sp.GetData(vx, vy);
		return sp.GetData(vx, vy, vnDatapointIndices, vnDataplotIndices);
		///end NORMALIZE_WITH_SELECTED_POINT_FROM_GRAPH_GET_WRONG_RESULT
	
	return 0;
}

/// Hong 03/26/08 QA80-11323 v8.0832b PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY
class GraphDoneDlg : public GraphGetPtsDlg
{
	GraphDoneDlg() : GraphGetPtsDlg()
	{}
	
	~GraphDoneDlg()
	{
		post_getn_dialog_message(WM_USER_ON_GRAPH_OBJECT_CHANGE, WPARAM_DONE_DLG_COSE);
#ifdef	_DEBUG_
		out_str("GraphDoneDlg::Destroy");
#endif
	}
	
EVENTS_BEGIN
	ON_BN_CLICKED(IDC_DONE, OnDone)
EVENTS_END
	BOOL OnDone(Control ctrl)
	{	
	#ifdef	_DEBUG_
		out_str("OnDone");
	#endif		
		SendMessage(WM_CLOSE);	
		//delete this;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
		return true;
	}
};

/**$
	This function create a done window as child window of the active GraphPage,
	it done nothing but only post a message WM_USER_ON_GRAPH_OBJECT_CHANGE to the GetN dialog 
	which attached to the page when close
*/
///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
//bool GetDoneDlg(LPCSTR lpcstrMsg, BOOL bAutoResize, LPCSTR lpcszTitle = NULL)
bool GetDoneDlg(DWORD& dwDlg, LPCSTR lpcstrMsg, BOOL bAutoResize, LPCSTR lpcszTitle = NULL)
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
{
	GraphPage gp = Project.Pages();
	if ( !gp )
		return false;
	/// Do NOT know what -1 mean here, copy from UserGetPts::openDlg, keep code above
	Window ww = gp.GetWindow(-1); /// TD 02-06-2008 QA80-11056 CHILD_DIALOG_TO_MDI_CHILD_FRAME (Get the drawing window)
	if ( !ww )
		return false;		
	
	HWND hWndParent = ww.GetSafeHwnd();
	GraphDoneDlg* pDlg = new GraphDoneDlg();
	pDlg->Create(hWndParent);
	SetFocus(hWndParent); /// TD 03-31-2008 QA80-11353  GRAPH_VIEW_LOOSES_KEYFOCUS_WHEN_CHILD_DIALOG
	//---- CPY 4/5/08 ADD_TITLE_TO_SMALL_GRAPH_DIALOG
	if(lpcszTitle && *lpcszTitle)
		pDlg->Text = lpcszTitle;
	//----
	pDlg->ShowDialog(false);
	
	pDlg->SetAutoSize(bAutoResize);/// YuI 04/02/08 OPTION_TO_AUTOSIZE_GETPOINTSDIALOG

	if ( NULL != lpcstrMsg )
		pDlg->ShowMsg(lpcstrMsg);
	
	dwDlg = (DWORD)pDlg;	///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
	
	return true;
}
/// end PA_PEAKS_ADD_DONE_DIALOG_WHEN_MODIFY

///Jasmine 02/19/09 QA80-13131 RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
bool CloseGetDoneDlg(DWORD dwDlg)
{
	GraphDoneDlg* pDlg = NULL;
	
	try
	{
		pDlg = (GraphDoneDlg*)dwDlg;
	}
	catch ( int nErr )
	{
		ASSERT(false);
		return false;
	}
	
#ifdef	_DEBUG_
		out_str("CloseGetDoneDlg");
#endif		
	
	if(pDlg)
	{
		pDlg->SendMessage(WM_CLOSE);
		return true;
	}
	
	return false;
}
///End RECEIVE_MSG_TO_CLOSE_GRAPHDONEDLG
